<?php

/*--- Custom fonts ---*/
function profex_get_fonts(){
	
	$body_font_name = get_theme_mod( 'body_font_name', 'Poppins:400,600' );
	$title_font_name = get_theme_mod( 'title_font_name', 'Montserrat:300,400,500,600,700,800,900' );
	
	$all_fonts = array();
	$all_fonts[] = esc_attr( str_replace( '+', ' ', $body_font_name ) );
	$all_fonts[] = esc_attr( str_replace( '+', ' ', $title_font_name ) );
	
	if( $all_fonts ){
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $all_fonts ) )
		), 'https://fonts.googleapis.com/css' );
	}
	
	return $fonts_url;
}

/*--- Custom excerpt length ---*/
function profex_custom_excerpt_length( $length ) {
	
	$exce_len = get_theme_mod('excerpt_len', 42);
	return $exce_len;
	
}
add_filter( 'excerpt_length', 'profex_custom_excerpt_length', 999 );


function profex_contact_info() {
		$toggle_contact = get_theme_mod('hide_top_contact');
		$phone 	 		= get_theme_mod('top_contact_num', '45-681-525');
		$email 	 		= get_theme_mod('top_contact_email', 'contact@domain.com');
		$address 		= get_theme_mod('top_contact_add', 'Wilson street, United Kingdom');
		if (!$toggle_contact) {
			echo '<div class="header-contact clearfix"><div class="container">';
				echo '<div class="header-contact-info">';
				if ($phone) {
				echo '<span class="col-md-4 col-sm-4 col-xs-12 header-phone">';
					echo '<i class="fa fa-phone"></i>' . '<a href="tel:' . esc_attr($phone) . '">' . esc_html($phone) . '</a>';
				echo '</span>';
				}
				if ($email) {
				echo '<span class="col-md-4 col-sm-4 col-xs-12 header-email">';
					echo '<i class="fa fa-envelope"></i>' . '<a href="mailto:' . antispambot($email) . '">' . antispambot($email) . '</a>';
				echo '</span>';
				}
				if ($address) {
				echo '<span class="col-md-4 col-sm-4 col-xs-12 header-address">';
					echo '<i class="fa fa-home"></i>' . esc_html($address);
				echo '</span>';
				}
				echo '</div>';
			echo '</div></div>';					
		}
	}
	
	function site_copyright(){
		$footer_copyright = get_theme_mod('footer_copyright', '<a href="http://themeworx.net/details/corporate/profex" >&copy; Profex Theme</a>');
		
		echo '<span>';
		printf( __('%1$s', 'profex'), $footer_copyright );
		echo '</span>';
	}
	
	function profex_mobile_header(){
		echo '<header id="mobi_header"  class="mobi_header" >';
			echo '<div class="container">';
				echo '<div class="row">';
				 echo '<div class="col-md-4 col-sm-6 col-xs-12">';
				  echo '<h3 class="site-title"><a href="' . esc_url( home_url( '/' ) ) . '" >' . esc_html( bloginfo( 'name' ) ) . '</a></h3>';
				  echo '</div>';
				  echo '<div class="col-md-8 col-sm-6 col-xs-12">';
					echo '<div class="btn-menu"></div> <nav id="site-navigation" class="site-navigation" role="navigation">' . wp_nav_menu( array( 'theme_location' => 'primary' ) ) . '</nav>';
				  echo '</div></div></div></header>';
				  
	}

?>