<?php

/*--- Countinued from free ---*/
add_action( 'customize_register', 'profex_pro_customize_register' );
function profex_pro_customize_register( $wp_customize ) {
	
		$wp_customize->get_section( 'colors' )->title = __('General', 'profex');
		$wp_customize->get_section( 'colors' )->panel = 'theme_color_panel';
		$wp_customize->get_section( 'colors' )->priority = 1;
	
	
		//Site title font size
		$wp_customize->add_setting( 'site_title_size', array(
			'capability' => 'edit_theme_options',
			'default' => '30',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'site_title_size', array(
			'priority' => 3,
			'type' => 'number',
			'section' => 'site_title_section',
			'settings' => 'site_title_size',
			'label' => __( 'Font size', 'profex' ),
			'description' => __( 'Change font size of site title', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 200,
				'step' => 1,
			),
			) );
			
		//Tagline font size
		$wp_customize->add_setting( 'tagline_size', array(
			'capability' => 'edit_theme_options',
			'default' => '15',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'tagline_size', array(
			'priority' => 3,
			'type' => 'number',
			'section' => 'site_tagline_section',
			'settings' => 'tagline_size',
			'label' => __( 'Font size', 'profex' ),
			'description' => __( 'Change font size of site tagline', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 200,
				'step' => 1,
			),
			) );
				
				
	//Site Menu section
	$wp_customize->add_section( 'header_menu_section', array(
		'title' => __( 'Menu style' , 'profex' ),
		'panel' => 'header_top_panel',
		'priority' => 3,
		'capability' => 'edit_theme_options',
		) );
		
		//Menu type
		$wp_customize->add_setting( 'menu_type', array(
			'capability' => 'edit_theme_options',
			'default' => 'sticky',
			'transport' => 'refresh',
			'sanitize_callback' => 'profex_sanitize_menu',
			) );
		
		$wp_customize->add_control( 'menu_type', array(
			'priority' => 1,
			'type' => 'radio',
			'section' => 'header_menu_section',
			'settings' => 'menu_type',
			'label' => __( 'Header menu type', 'profex' ),
			'description' => __( 'Select header menu type from the following', 'profex' ),
			'choices' => array(
				'static' => __( 'Static', 'profex' ),
				'sticky' => __( 'Sticky', 'profex' ),
			),
			) );
		
		//Top level menu color
		$wp_customize->add_setting( 'top_menu_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#ffffff',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'top_menu_color', array(
				'priority' => 2,
				'section' => 'header_menu_section',
				'settings' => 'top_menu_color',
				'label' => __( 'Top level menu Color', 'profex' ),
				'description' => __( 'Change color of top level menu items', 'profex' ),
				) ) );
				
		//Top level menu bg color
		$wp_customize->add_setting( 'top_menu_bg_color', array(
			'capability' => 'edit_theme_options',
			'default' => '',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'top_menu_bg_color', array(
				'priority' => 3,
				'section' => 'header_menu_section',
				'settings' => 'top_menu_bg_color',
				'label' => __( 'Top level menu background Color', 'profex' ),
				'description' => __( 'Change background color of top level menu items', 'profex' ),
				) ) );
		
		//Top level menu size
		$wp_customize->add_setting( 'top_menu_size', array(
			'capability' => 'edit_theme_options',
			'default' => '15',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'top_menu_size', array(
			'priority' => 4,
			'type' => 'number',
			'section' => 'header_menu_section',
			'settings' => 'top_menu_size',
			'label' => __( 'Top level menu size', 'profex' ),
			'description' => __( 'Change font size of top level menu items', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 200,
				'step' => 1,
			),
			) );
		
		//Sub menu color
		$wp_customize->add_setting( 'sub_menu_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#ffffff',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'sub_menu_color', array(
				'priority' => 5,
				'section' => 'header_menu_section',
				'settings' => 'sub_menu_color',
				'label' => __( 'Sub menu Color', 'profex' ),
				'description' => __( 'Change color of sub menu items', 'profex' ),
				) ) );
				
		//Sub menu color
		$wp_customize->add_setting( 'sub_menu_bg_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#333333',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'sub_menu_bg_color', array(
				'priority' => 6,
				'section' => 'header_menu_section',
				'settings' => 'sub_menu_bg_color',
				'label' => __( 'Sub menu background Color', 'profex' ),
				'description' => __( 'Change background color of sub menu items', 'profex' ),
				) ) );
		
		//Sub menu size
		$wp_customize->add_setting( 'sub_menu_size', array(
			'capability' => 'edit_theme_options',
			'default' => '15',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'sub_menu_size', array(
			'priority' => 7,
			'type' => 'number',
			'section' => 'header_menu_section',
			'settings' => 'sub_menu_size',
			'label' => __( 'Sub menu size', 'profex' ),
			'description' => __( 'Change font size of sub menu items', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 200,
				'step' => 1,
			),
			) );
			
		//Menu hover color
		$wp_customize->add_setting( 'menu_hover_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#943A4D',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'menu_hover_color', array(
				'priority' => 8,
				'section' => 'header_menu_section',
				'settings' => 'menu_hover_color',
				'label' => __( 'Menu hover Color', 'profex' ),
				'description' => __( 'Change color on menu hover', 'profex' ),
				) ) );
		
		//sub Menu  hover color
		$wp_customize->add_setting( 'Sub_menu_hover_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#fffff',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'Sub_menu_hover_color', array(
				'priority' => 8,
				'section' => 'header_menu_section',
				'settings' => 'Sub_menu_hover_color',
				'label' => __( 'Sub Menu hover Color', 'profex' ),
				'description' => __( 'Change color on menu hover', 'profex' ),
				) ) );
		
		//sub Menu background hover color
		$wp_customize->add_setting( 'Sub_menu_bg_hover_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#943A4D',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'Sub_menu_bg_hover_color', array(
				'priority' => 8,
				'section' => 'header_menu_section',
				'settings' => 'Sub_menu_bg_hover_color',
				'label' => __( 'Sub Menu background hover Color', 'profex' ),
				'description' => __( 'Change color on menu hover', 'profex' ),
				) ) );
				
		//Menu button color
		$wp_customize->add_setting( 'menu_btn_color', array(
			'capability' => 'edit_theme_options',
			'default' => '',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'menu_btn_color', array(
				'priority' => 9,
				'section' => 'header_menu_section',
				'settings' => 'menu_btn_color',
				'label' => __( 'Menu button Color', 'profex' ),
				'description' => __( 'Change color of menu button appears for mobile menu', 'profex' ),
				) ) );
	
	//Top section style
	$wp_customize->add_section( 'header_top_style', array(
		'title' => __( 'Section style' , 'profex' ),
		'panel' => 'header_top_panel',
		'priority' => 4,
		'capability' => 'edit_theme_options',
		) );
		
		//Header top background
		$wp_customize->add_setting( 'header_top_background', array(
			'capability' => 'edit_theme_options',
			'default' => '#09090B',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'header_top_background', array(
				'priority' => 1,
				'section' => 'header_top_style',
				'settings' => 'header_top_background',
				'label' => __( 'Background color', 'profex' ),
				'description' => __( 'Change background color of header top section', 'profex' ),
				) ) );
	
	//Banner type pro control
		$wp_customize->add_control( 'banner_type', array(
					'priority' => 1,
					'type' => 'radio',
					'section' => 'banner_type_section',
					'settings' => 'banner_type',
					'label' => __( 'Fron page banner type', 'profex' ),
					'description' => __( 'Select banner type for front page', 'profex' ),
					'choices' => array(
						'bg-color' => __( 'Background Color', 'profex' ),
						'bg-gradient' => __( 'Background Gradient', 'profex' ),
						'image' => __( 'Background Image', 'profex' ),
						'video' => __( 'Background Video', 'profex' ),
						'carousel' => __( 'Background Carousel', 'profex' ),
					),
					) );
				
	//Banner other page
	$wp_customize->add_section( 'banner_other_page', array(
		'title' => __( 'Banner other pages' , 'profex' ),
		'panel' => 'header_banner',
		'priority' => 6,
		'capability' => 'edit_theme_options',
		) );
		
		//Banner other page background image
		$wp_customize->add_setting( 'other_bg_img', array(
			'capability' => 'edit_theme_options',
			'default' => get_stylesheet_directory_uri() . '/images/banner1.jpg',
			'transport' => 'refresh',
			'sanitize_callback' => 'esc_url_raw',
			) );
		
		$wp_customize->add_control( new WP_Customize_Image_Control(
			$wp_customize, 'other_bg_img', array(
				'priority' => 1,
				'type' => 'image',
				'section' => 'banner_other_page',
				'settings' => 'other_bg_img',
				'label' => __( 'Upload image for other page background', 'profex' ),
				) ) );
	
		//Show or hide breadcrumb
		$wp_customize->add_setting( 'show_breadcrumb', array(
			'capability' => 'edit_theme_options',
			'default' => 1,
			'transport' => 'refresh',
			'sanitize_callback' => 'twx_sntz_checkbox',
			) );
		
		$wp_customize->add_control( 'show_breadcrumb', array(
			'priority' => 2,
			'type' => 'checkbox',
			'section' => 'banner_other_page',
			'settings' => 'show_breadcrumb',
			'label' => __( 'Show breadcrumb', 'profex' ),
			'description' => __( 'Check this box to show breadcrumb on other pages than front page', 'profex' ),
			) );
				
		//Other page banner height
		$wp_customize->add_setting( 'other_banner_height', array(
			'capability' => 'edit_theme_options',
			'default' => '350',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'other_banner_height', array(
			'priority' => 3,
			'type' => 'number',
			'section' => 'banner_other_page',
			'settings' => 'other_banner_height',
			'label' => __( 'Height of other page banner (Default: 350px)', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 2000,
				'step' => 1,
			),
			) );
				
	//Blog excerpt
	$wp_customize->add_section( 'blog_excerpt', array(
		'title' => __( 'Blog excerpt' , 'profex' ),
		'panel' => 'theme_blog_panel',
		'priority' => 2,
		'capability' => 'edit_theme_options',
		) );
		
		//Blog excerpt length
		$wp_customize->add_setting( 'excerpt_len', array(
			'capability' => 'edit_theme_options',
			'default' => '42',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'excerpt_len', array(
			'priority' => 1,
			'type' => 'number',
			'section' => 'blog_excerpt',
			'settings' => 'excerpt_len',
			'label' => __( 'Length of excerpt', 'profex' ),
			'description' => __( 'Enter the count of words to show in blogs content on blog page', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 100,
				'step' => 1,
			),
			) );
			
	/*--- Color panel ---*/
	$wp_customize->add_panel( 'theme_color_panel', array(
		'title' => __( 'Colors Panel', 'profex' ),
		'priority' => 5,
		) );
		
		//Headings color section
		$wp_customize->add_section( 'title_color_section', array(
			'title' => __( 'Title colors' , 'profex' ),
			'panel' => 'theme_color_panel',
			'priority' => 2,
			'capability' => 'edit_theme_options',
			'description' => __( 'Change the color for all the headings', 'profex' ),
			) );
			
			//H1 title color
			$wp_customize->add_setting( 'h1_title_color', array(
				'capability' => 'edit_theme_options',
				'default' => '#443f3f',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_hex_color',
				) );
			
			$wp_customize->add_control( new WP_Customize_Color_Control(
				$wp_customize, 'h1_title_color', array(
					'priority' => 1,
					'section' => 'title_color_section',
					'settings' => 'h1_title_color',
					'label' => __( 'H1 title Color', 'profex' ),
					) )
				);
				
			//H2 title color
			$wp_customize->add_setting( 'h2_title_color', array(
				'capability' => 'edit_theme_options',
				'default' => '#443f3f',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_hex_color',
				) );
			
			$wp_customize->add_control( new WP_Customize_Color_Control(
				$wp_customize, 'h2_title_color', array(
					'priority' => 2,
					'section' => 'title_color_section',
					'settings' => 'h2_title_color',
					'label' => __( 'H2 title Color', 'profex' ),
					) )
				);
				
			//H3 title color
			$wp_customize->add_setting( 'h3_title_color', array(
				'capability' => 'edit_theme_options',
				'default' => '#443f3f',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_hex_color',
				) );
			
			$wp_customize->add_control( new WP_Customize_Color_Control(
				$wp_customize, 'h3_title_color', array(
					'priority' => 3,
					'section' => 'title_color_section',
					'settings' => 'h3_title_color',
					'label' => __( 'H3 title Color', 'profex' ),
					) )
				);
				
			//H4 title color
			$wp_customize->add_setting( 'h4_title_color', array(
				'capability' => 'edit_theme_options',
				'default' => '#443f3f',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_hex_color',
				) );
			
			$wp_customize->add_control( new WP_Customize_Color_Control(
				$wp_customize, 'h4_title_color', array(
					'priority' => 4,
					'section' => 'title_color_section',
					'settings' => 'h4_title_color',
					'label' => __( 'H4 title Color', 'profex' ),
					) )
				);
				
			//H5 title color
			$wp_customize->add_setting( 'h5_title_color', array(
				'capability' => 'edit_theme_options',
				'default' => '#443f3f',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_hex_color',
				) );
			
			$wp_customize->add_control( new WP_Customize_Color_Control(
				$wp_customize, 'h5_title_color', array(
					'priority' => 5,
					'section' => 'title_color_section',
					'settings' => 'h5_title_color',
					'label' => __( 'H5 title Color', 'profex' ),
					) )
				);
				
			//H6 title color
			$wp_customize->add_setting( 'h6_title_color', array(
				'capability' => 'edit_theme_options',
				'default' => '#443f3f',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_hex_color',
				) );
			
			$wp_customize->add_control( new WP_Customize_Color_Control(
				$wp_customize, 'h6_title_color', array(
					'priority' => 6,
					'section' => 'title_color_section',
					'settings' => 'h6_title_color',
					'label' => __( 'H6 title Color', 'profex' ),
					) )
				);
	
	/*------- Free End ---*/
	
	
	
	/*--- New addition for pro ---*/
				
		
	//Top contact row
	$wp_customize->add_section( 'top_contact_section', array(
		'title' => __( 'Top contact row' , 'profex' ),
		'panel' => 'header_top_panel',
		'priority' => 5,
		'capability' => 'edit_theme_options',
		) );
		
		//Top contact bg color
		$wp_customize->add_setting( 'contact_bg_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#1c1c1c',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'contact_bg_color', array(
				'priority' => 1,
				'section' => 'top_contact_section',
				'settings' => 'contact_bg_color',
				'label' => __( 'Background Color', 'profex' ),
				) )
			);
			
		//Top contact text color
		$wp_customize->add_setting( 'contact_text_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#ffffff',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'contact_text_color', array(
				'priority' => 2,
				'section' => 'top_contact_section',
				'settings' => 'contact_text_color',
				'label' => __( 'Contact text Color', 'profex' ),
				) )
			);
			
		//Top contact email
		$wp_customize->add_setting( 'top_contact_email', array(
			'capability' => 'edit_theme_options',
			'default' => __( 'contact@domain.com', 'profex' ),
			'transport' => 'refresh',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		
		$wp_customize->add_control( 'top_contact_email', array(
			'priority' => 3,
			'type' => 'text',
			'section' => 'top_contact_section',
			'settings' => 'top_contact_email',
			'label' => __( 'Contact Email', 'profex' ),
			) );
			
		//Top contact address
		$wp_customize->add_setting( 'top_contact_add', array(
			'capability' => 'edit_theme_options',
			'default' => __( 'Wilson street, United Kingdom', 'profex' ),
			'transport' => 'refresh',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		
		$wp_customize->add_control( 'top_contact_add', array(
			'priority' => 4,
			'type' => 'text',
			'section' => 'top_contact_section',
			'settings' => 'top_contact_add',
			'label' => __( 'Contact Address', 'profex' ),
			) );
		
		//Top contact number
		$wp_customize->add_setting( 'top_contact_num', array(
			'capability' => 'edit_theme_options',
			'default' => __( '45-681-525', 'profex' ),
			'transport' => 'refresh',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		
		$wp_customize->add_control( 'top_contact_num', array(
			'priority' => 5,
			'type' => 'text',
			'section' => 'top_contact_section',
			'settings' => 'top_contact_num',
			'label' => __( 'Contact Number', 'profex' ),
			) );
		
		//Hide contact info	
		$wp_customize->add_setting( 'hide_top_contact', array(
			'capability' => 'edit_theme_options',
			'default' => 0,
			'transport' => 'refresh',
			'sanitize_callback' => 'twx_sntz_checkbox',
			) );
		
		$wp_customize->add_control( 'hide_top_contact', array(
			'priority' => 6,
			'type' => 'checkbox',
			'section' => 'top_contact_section',
			'settings' => 'hide_top_contact',
			'label' => __( 'Check this box to hide top contact information section', 'profex' ),
			) );
			
	//Button style section
	$wp_customize->add_section( 'button_style', array(
		'title' => __( 'Button styles' , 'profex' ),
		'panel' => 'general_settings',
		'priority' => 2,
		'capability' => 'edit_theme_options',
		'description' => __( 'Form here you can change the style for button', 'profex' ),
		) );
		
		//Button bg color
		$wp_customize->add_setting( 'btn_bg_color', array(
			'capability' => 'edit_theme_options',
			'default' => '',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'btn_bg_color', array(
				'priority' => 1,
				'section' => 'button_style',
				'settings' => 'btn_bg_color',
				'label' => __( 'Background Color', 'profex' ),
				) )
			);
			
		//Button text color
		$wp_customize->add_setting( 'btn_text_color', array(
			'capability' => 'edit_theme_options',
			'default' => '',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'btn_text_color', array(
				'priority' => 2,
				'section' => 'button_style',
				'settings' => 'btn_text_color',
				'label' => __( 'Text Color', 'profex' ),
				) )
			);
			
		//Button hover bg color
		$wp_customize->add_setting( 'btn_hover_bg_color', array(
			'capability' => 'edit_theme_options',
			'default' => '',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'btn_hover_bg_color', array(
				'priority' => 2,
				'section' => 'button_style',
				'settings' => 'btn_hover_bg_color',
				'label' => __( 'Hover background Color', 'profex' ),
				) )
			);
			
		//Button hover text color
		$wp_customize->add_setting( 'btn_hover_text_color', array(
			'capability' => 'edit_theme_options',
			'default' => '',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'btn_hover_text_color', array(
				'priority' => 2,
				'section' => 'button_style',
				'settings' => 'btn_hover_text_color',
				'label' => __( 'Hover text Color', 'profex' ),
				) )
			);
			
		//Button top and bottom padding
		$wp_customize->add_setting( 'tb_btn_padding', array(
			'capability' => 'edit_theme_options',
			'default' => '15',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'tb_btn_padding', array(
			'priority' => 3,
			'type' => 'number',
			'section' => 'button_style',
			'settings' => 'tb_btn_padding',
			'label' => __( 'Top and bottom padding of button', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 100,
				'step' => 1,
			),
			) );
			
		//Button left and right padding
		$wp_customize->add_setting( 'lr_btn_padding', array(
			'capability' => 'edit_theme_options',
			'default' => '30',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'lr_btn_padding', array(
			'priority' => 4,
			'type' => 'number',
			'section' => 'button_style',
			'settings' => 'lr_btn_padding',
			'label' => __( 'Left and right padding of button', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 100,
				'step' => 1,
			),
			) );
			
		//Button border radius
		$wp_customize->add_setting( 'btn_border_radius', array(
			'capability' => 'edit_theme_options',
			'default' => '3',
			'transport' => 'refresh',
			'sanitize_callback' => 'absint',
			) );
		
		$wp_customize->add_control( 'btn_border_radius', array(
			'priority' => 5,
			'type' => 'number',
			'section' => 'button_style',
			'settings' => 'btn_border_radius',
			'label' => __( 'Border radius', 'profex' ),
			'input_attrs' => array(
				'min' => 0,
				'max' => 100,
				'step' => 1,
			),
			) );
			
	//Footer section
	$wp_customize->add_section( 'theme_footer', array(
		'title' => __( 'Footer' , 'profex' ),
		'panel' => 'general_settings',
		'priority' => 3,
		'capability' => 'edit_theme_options',
		) );
		
		//Footer copyright
		$wp_customize->add_setting( 'footer_copyright', array(
			'capability' => 'edit_theme_options',
			'default' => '<a href="http://themeworx.net/details/corporate/profex" >&copy; Profex Theme</a>',
			'transport' => 'refresh',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		
		$wp_customize->add_control( 'footer_copyright', array(
			'priority' => 1,
			'type' => 'text',
			'section' => 'theme_footer',
			'settings' => 'footer_copyright',
			'label' => __( 'Footer copyright text', 'profex' ),
			'description' => __( 'Change footer copyright text to your text ( Html Allowed )', 'profex' ),
			) );
			
		//Widget area background color
		$wp_customize->add_setting( 'widget_area_bg', array(
			'capability' => 'edit_theme_options',
			'default' => '#59cdf2',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'widget_area_bg', array(
				'priority' => 2,
				'section' => 'theme_footer',
				'settings' => 'widget_area_bg',
				'label' => __( 'Widget area background color', 'profex' ),
				'description' => __( 'Change background color of footer widget area', 'profex' ),
				) ) );
				
		//Widget area color
		$wp_customize->add_setting( 'widget_area_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#ffffff',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'widget_area_color', array(
				'priority' => 3,
				'section' => 'theme_footer',
				'settings' => 'widget_area_color',
				'label' => __( 'Widget area color', 'profex' ),
				'description' => __( 'Change color of footer widget area', 'profex' ),
				) ) );
				
		//Main footer bg color
		$wp_customize->add_setting( 'main_footer_bg', array(
			'capability' => 'edit_theme_options',
			'default' => '#59cdf2',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'main_footer_bg', array(
				'priority' => 4,
				'section' => 'theme_footer',
				'settings' => 'main_footer_bg',
				'label' => __( 'Main footer background color', 'profex' ),
				'description' => __( 'Change background color of footer', 'profex' ),
				) ) );
				
		//Main footer color
		$wp_customize->add_setting( 'main_footer_color', array(
			'capability' => 'edit_theme_options',
			'default' => '#ffffff',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
			) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'main_footer_color', array(
				'priority' => 5,
				'section' => 'theme_footer',
				'settings' => 'main_footer_color',
				'label' => __( 'Main footer color', 'profex' ),
				) ) );
			
	/*--- Fonts panel ---*/
	$wp_customize->add_panel( 'theme_fonts_panel', array(
		'title' => __( 'Fonts Panel', 'profex' ),
		'priority' => 6,
		) );
		
		//Body font section
		$wp_customize->add_section( 'body_fonts', array(
			'title' => __( 'Body Fonts' , 'profex' ),
			'panel' => 'theme_fonts_panel',
			'priority' => 1,
			'capability' => 'edit_theme_options',
			) );
			
			//Body font name
			$wp_customize->add_setting( 'body_font_name', array(
				'capability' => 'edit_theme_options',
				'default' => 'Poppins:400,600',
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			
			$wp_customize->add_control( 'body_font_name', array(
				'priority' => 1,
				'type' => 'text',
				'section' => 'body_fonts',
				'settings' => 'body_font_name',
				'label' => __( 'Body font name', 'profex' ),
				) );
				
			//Body font family
			$wp_customize->add_setting( 'body_font_family', array(
				'capability' => 'edit_theme_options',
				'default' => '\'Poppins\', sans-serif',
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			
			$wp_customize->add_control( 'body_font_family', array(
				'priority' => 2,
				'type' => 'text',
				'section' => 'body_fonts',
				'settings' => 'body_font_family',
				'label' => __( 'Body font family', 'profex' ),
				) );
				
			//Body font size
			$wp_customize->add_setting( 'body_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 16,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'body_font_size', array(
				'priority' => 3,
				'type' => 'number',
				'section' => 'body_fonts',
				'settings' => 'body_font_size',
				'label' => __( 'Body font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 100,
					'step' => 1,
				),
				) );
				
		//All heading font section(h1,h2,h3,h4,h5,h6)
		$wp_customize->add_section( 'title_fonts', array(
			'title' => __( 'Title Fonts' , 'profex' ),
			'panel' => 'theme_fonts_panel',
			'priority' => 2,
			'capability' => 'edit_theme_options',
			'description' => __( 'Here you can change the fonts for all the heading (h1, h2, h3, h4, h5, h6).', 'profex' ),
			) );
			
			//Title font name
			$wp_customize->add_setting( 'title_font_name', array(
				'capability' => 'edit_theme_options',
				'default' => 'Montserrat:300,400,500,600,700,800,900',
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			
			$wp_customize->add_control( 'title_font_name', array(
				'priority' => 1,
				'type' => 'text',
				'section' => 'title_fonts',
				'settings' => 'title_font_name',
				'label' => __( 'Title font name', 'profex' ),
				) );
				
			//Title font family
			$wp_customize->add_setting( 'title_font_family', array(
				'capability' => 'edit_theme_options',
				'default' => '\'Montserrat\', sans-serif',
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			
			$wp_customize->add_control( 'title_font_family', array(
				'priority' => 2,
				'type' => 'text',
				'section' => 'title_fonts',
				'settings' => 'title_font_family',
				'label' => __( 'Title font family', 'profex' ),
				) );
				
			//H1 font size
			$wp_customize->add_setting( 'h1_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 50,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'h1_font_size', array(
				'priority' => 3,
				'type' => 'number',
				'section' => 'title_fonts',
				'settings' => 'h1_font_size',
				'label' => __( 'H1 font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 200,
					'step' => 1,
				),
				) );
				
			//H2 font size
			$wp_customize->add_setting( 'h2_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 42,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'h2_font_size', array(
				'priority' => 4,
				'type' => 'number',
				'section' => 'title_fonts',
				'settings' => 'h2_font_size',
				'label' => __( 'H2 font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 200,
					'step' => 1,
				),
				) );
				
			//H3 font size
			$wp_customize->add_setting( 'h3_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 32,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'h3_font_size', array(
				'priority' => 5,
				'type' => 'number',
				'section' => 'title_fonts',
				'settings' => 'h3_font_size',
				'label' => __( 'H3 font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 200,
					'step' => 1,
				),
				) );
				
			//H4 font size
			$wp_customize->add_setting( 'h4_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 25,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'h4_font_size', array(
				'priority' => 6,
				'type' => 'number',
				'section' => 'title_fonts',
				'settings' => 'h4_font_size',
				'label' => __( 'H4 font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 200,
					'step' => 1,
				),
				) );
				
			//H5 font size
			$wp_customize->add_setting( 'h5_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 20,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'h5_font_size', array(
				'priority' => 7,
				'type' => 'number',
				'section' => 'title_fonts',
				'settings' => 'h5_font_size',
				'label' => __( 'H5 font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 200,
					'step' => 1,
				),
				) );
				
			//H6 font size
			$wp_customize->add_setting( 'h6_font_size', array(
				'capability' => 'edit_theme_options',
				'default' => 18,
				'transport' => 'refresh',
				'sanitize_callback' => 'absint',
				) );
			
			$wp_customize->add_control( 'h6_font_size', array(
				'priority' => 8,
				'type' => 'number',
				'section' => 'title_fonts',
				'settings' => 'h6_font_size',
				'label' => __( 'H6 font size', 'profex' ),
				'input_attrs' => array(
					'min' => 0,
					'max' => 200,
					'step' => 1,
				),
				) );
				
	//Woocommerce extraa
	$wp_customize->add_section( 'wc_extraa_sec', array(
		'title' => __( 'Woocommerce Extraa' , 'profex' ),
		'priority' => 7,
		'capability' => 'edit_theme_options',
		) );
		
		//Show or hide woocommerce nav in top
		$wp_customize->add_setting( 'show_wc_nav', array(
			'capability' => 'edit_theme_options',
			'default' => 1,
			'transport' => 'refresh',
			'sanitize_callback' => 'twx_sntz_checkbox',
			) );
		
		$wp_customize->add_control( 'show_wc_nav', array(
			'priority' => 1,
			'type' => 'checkbox',
			'section' => 'wc_extraa_sec',
			'settings' => 'show_wc_nav',
			'label' => __( 'Show cart and account link in menu', 'profex' ),
			'description' => __( 'Check this box to show cart and account link in menu', 'profex' ),
			) );
			
		//wc widgets position
		$wp_customize->add_setting( 'wc_widgets_pos', array(
			'capability' => 'edit_theme_options',
			'default' => 'right',
			'transport' => 'refresh',
			'sanitize_callback' => 'profex_sanitize_wc_pos',
			) );
		
		$wp_customize->add_control( 'wc_widgets_pos', array(
			'priority' => 2,
			'type' => 'radio',
			'section' => 'wc_extraa_sec',
			'settings' => 'wc_widgets_pos',
			'label' => __( 'Header menu type', 'profex' ),
			'description' => __( 'Select header menu type from the following', 'profex' ),
			'choices' => array(
				'left' => __( 'Left', 'profex' ),
				'right' => __( 'Right', 'profex' ),
			),
			) );
		
		
				
	/*--- Footer panel ---*/
	/* $wp_customize->add_panel( 'theme_footer_panel', array(
		'title' => __( 'Footer Panel', 'profex' ),
		'priority' => 7,
		) ); */
	



//___Slider slide 1___//
		$wp_customize->add_section( 'banner_bg_slider_section1', array(
			'title' => __( 'Banner Background: slider 1' , 'profex' ),
			'panel' => 'header_banner',
			'priority' => 7,
			'capability' => 'edit_theme_options',
			'description' => __( 'Here you can add the slider image and content for the first slide', 'profex' ),
			) );
			
		//slider height
		$wp_customize->add_setting(
			'slider_height',
			array(
				'default'           => '700',
				'capability'		=> 'edit_theme_options',
				'sanitize_callback' => 'absint',
			) );
		$wp_customize->add_control( 'slider_height', array(
			'type'        => 'number',
			'priority'    => 10,
			'section'     => 'banner_bg_slider_section1',
			'label'       => __('slider height [default: 700px]', 'profex'),
			'input_attrs' => array(
				'min'   => 250,
				'max'   => 1000,
				'step'  => 5,
			),
		) );
		//Image 1
		    
		$wp_customize->add_setting(
			'slider_image_1',
			array(
				'default' => get_stylesheet_directory_uri() . '/images/banner1.jpg',
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'slider_image_1',
				array(
				   'label'          => __( 'Upload your first image for the slider', 'profex' ),
				   'type'           => 'image',
				   'section'        => 'banner_bg_slider_section1',
				   'settings'       => 'slider_image_1',
				   'priority'       => 11,
				)
			) );
		
		//Title
		$wp_customize->add_setting(
			'slider_title_1',
			array(
				'default' 			=> __('We deliver lasting business and  customer benefits','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			));
		$wp_customize->add_control(
			'slider_title_1',
			array(
				'label' => __( 'Title for the first slide', 'profex' ),
				'section' => 'banner_bg_slider_section1',
				'type' => 'text',
				'priority' => 12
			) );
		$wp_customize->add_control(
			'slider_subtitle_1',
			array(
				'label' => __( 'Subtitle for the first slide', 'profex' ),
				'section' => 'banner_bg_slider_section1',
				'type' => 'text',
				'priority' => 13
			) );
		//Subpera
		$wp_customize->add_setting(
			'slider_subpera_1',
			array(
				'default' 			=> __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi imperdiet ullamcorper erat,','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_subpera_1',
			array(
				'label' 	=> __( 'Subpera for the first slide', 'profex' ),
				'section' 	=> 'banner_bg_slider_section1',
				'type' 		=> 'text',
				'priority' 	=> 13
			) );
		
		//Button1
		$wp_customize->add_setting(
			'slider_button_1',
			array(
				'default' => __('View More','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_button_1',
			array(
				'label' => __( 'Text on the button 1', 'profex' ),
				'section' => 'banner_bg_slider_section1',
				'type' => 'text',
				'priority' => 14
			) );
		//Button URL1
		$wp_customize->add_setting(
			'slider_button_url_1',
			array(
				'default' => __('#','profex'),
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			'slider_button_url_1',
			array(
				'label' => __( 'URL for the banner button 1', 'profex' ),
				'section' => 'banner_bg_slider_section1',
				'type' => 'text',
				'priority' => 15
			) );
		
		//Button2
		$wp_customize->add_setting(
			'slider_button2_1',
			array(
				'default'  			=> __('View More','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_button2_1',
			array(
				'label' => __( 'Text on the button 2', 'profex' ),
				'section' => 'banner_bg_slider_section1',
				'type' => 'text',
				'priority' => 16
			) );
		//Button URL2
		$wp_customize->add_setting(
			'slider_button_url2_1',
			array(
				'default' => __('#','profex'),
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			'slider_button_url2_1',
			array(
				'label' => __( 'URL for the banner button 2', 'profex' ),
				'section' => 'banner_bg_slider_section1',
				'type' => 'text',
				'priority' => 16
			) );
		//front image
		/* $wp_customize->add_setting(
			'slider_front_img_1',
			array(
				'default' => get_stylesheet_directory_uri() . '/images/banner-img-01.png',
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'slider_front_img_1',
				array(
				   'label'          => __( 'Upload your  front image for the first slide', 'profex' ),
				   'type'           => 'image',
				   'section'        => 'banner_bg_slider_section1',
				   'settings'       => 'slider_front_img_1',
				   'priority'       => 16,
				)
			) ); */
   
				
			//___Slider slide 2___//
		$wp_customize->add_section( 'banner_bg_slider_section2', array(
			'title' => __( 'Banner Background: slider 2' , 'profex' ),
			'panel' => 'header_banner',
			'priority' => 8,
			'capability' => 'edit_theme_options',
			'description' => __( 'Here you can add the slider image and content for the second slide', 'profex' ),
			) );
			
			$wp_customize->add_setting(
				'slider_image_2',
				array(
					'default' => get_stylesheet_directory_uri() . '/images/banner2.jpg',
					'sanitize_callback' => 'esc_url_raw',
				)
			);
			$wp_customize->add_control(
				new WP_Customize_Image_Control(
					$wp_customize,
					'slider_image_2',
					array(
					   'label'          => __( 'Upload your second image for the slider', 'profex' ),
					   'type'           => 'image',
					   'section'        => 'banner_bg_slider_section2',
					   'settings'       => 'slider_image_2',
					   'priority'       => 17,
					)
				) );
			//Title
			$wp_customize->add_setting(
				'slider_title_2',
				array(
					'default' => __('We are passionate about making a measurable impact in all we do !','profex'),
					'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			$wp_customize->add_control(
				'slider_title_2',
				array(
					'label' => __( 'Title for the second slide', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 18
				) );
			//Subtitle
			$wp_customize->add_setting(
				'slider_subtitle_2',
				array(
					'default' => __('Click the button below','profex'),
					'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			$wp_customize->add_control(
				'slider_subtitle_2',
				array(
					'label' => __( 'Subtitle for the second slide', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 19
				) );
			//Subpera
			$wp_customize->add_setting(
				'slider_subpera_2',
				array(
					'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi imperdiet ullamcorper erat,','profex'),
					'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			$wp_customize->add_control(
				'slider_subpera_2',
				array(
					'label' => __( 'Subpera for the second slide', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 19
				) );
			
			//Button
			$wp_customize->add_setting(
				'slider_button_2',
				array(
					'default' => __('Begin Now','profex'),
					'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			$wp_customize->add_control(
				'slider_button_2',
				array(
					'label' => __( 'Text on the button 1', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 21
				) );
			//Button URL
			$wp_customize->add_setting(
				'slider_button_url_2',
				array(
					'default' => __('#','profex'),
					'sanitize_callback' => 'esc_url_raw',
				) );
			$wp_customize->add_control(
				'slider_button_url_2',
				array(
					'label' => __( 'URL for the banner button 1', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 21
				) );
			
			//Button2
			$wp_customize->add_setting(
				'slider_button2_2',
				array(
					'default' => __('Begin Now','profex'),
					'sanitize_callback' => 'wp_filter_nohtml_kses',
				) );
			$wp_customize->add_control(
				'slider_button2_2',
				array(
					'label' => __( 'Text on the button 2', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 22
				) );
			//Button URL2
			$wp_customize->add_setting(
				'slider_button_url2_2',
				array(
					'default' => __('#','profex'),
					'sanitize_callback' => 'esc_url_raw',
				) );
			$wp_customize->add_control(
				'slider_button_url2_2',
				array(
					'label' => __( 'URL for the banner button 2', 'profex' ),
					'section' => 'banner_bg_slider_section2',
					'type' => 'text',
					'priority' => 22
				) );
			/* //front image
			$wp_customize->add_setting(
				'slider_front_img_2',
				array(
					'default' => get_stylesheet_directory_uri() . '/images/banner-img-01.png',
					'sanitize_callback' => 'esc_url_raw',
				) );
			$wp_customize->add_control(
				new WP_Customize_Image_Control(
					$wp_customize,
					'slider_front_img_2',
					array(
					   'label'          => __( 'Upload your  front image for the second slide', 'profex' ),
					   'type'           => 'image',
					   'section'        => 'banner_bg_slider_section2',
					   'settings'       => 'slider_front_img_2',
					   'priority'       => 22,
					)
				) ); */
		
			//___Slider slide 3___//
		$wp_customize->add_section( 'banner_bg_slider_section3', array(
			'title' => __( 'Banner Background: slider 3' , 'profex' ),
			'panel' => 'header_banner',
			'priority' => 9,
			'capability' => 'edit_theme_options',
			'description' => __( 'Here you can add the slider image and content for the third slide', 'profex' ),
			) );
			
		$wp_customize->add_setting(
			'slider_image_3',
			array(
				'default' => get_stylesheet_directory_uri() . '/images/banner3.jpg',
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'slider_image_3',
				array(
				   'label'          => __( 'Upload your third image for the slider', 'profex' ),
				   'type'           => 'image',
				   'section'        => 'banner_bg_slider_section3',
				   'settings'       => 'slider_image_3',
				   'priority'       => 23,
				)
			) );
		//Title
		$wp_customize->add_setting(
			'slider_title_3',
			array(
				'default' => __('Great people working on toughest problems','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_title_3',
			array(
				'label' => __( 'Title for the third slide', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 24
			) );
		//Subtitle
		$wp_customize->add_setting(
			'slider_subtitle_3',
			array(
				'default' => '',
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_subtitle_3',
			array(
				'label' => __( 'Subtitle for the third slide', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 25
			) );
		
		//Subpera
		$wp_customize->add_setting(
			'slider_subpera_3',
			array(
				'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi imperdiet ullamcorper erat,','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_subpera_3',
			array(
				'label' => __( 'Subpera for the third slide', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 25                         
			) );
		
		//Button
		$wp_customize->add_setting(
			'slider_button_3',
			array(
				'default' => __('','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_button_3',
			array(
				'label' => __( 'Text on the button 1', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 26
			) );
		//Button URL
		$wp_customize->add_setting(
			'slider_button_url_3',
			array(
				'default' => __('','profex'),
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			'slider_button_url_3',
			array(
				'label' => __( 'URL for the banner button 1', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 27
			) );
		
		//Button2
		$wp_customize->add_setting(
			'slider_button2_3',
			array(
				'default' => __('','profex'),
				'sanitize_callback' => 'wp_filter_nohtml_kses',
			) );
		$wp_customize->add_control(
			'slider_button2_3',
			array(
				'label' => __( 'Text on the button 2', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 28
			) );
		//Button URL
		$wp_customize->add_setting(
			'slider_button_url2_3',
			array(
				'default' => __('','profex'),
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			'slider_button_url2_3',
			array(
				'label' => __( 'URL for the banner button 2', 'profex' ),
				'section' => 'banner_bg_slider_section3',
				'type' => 'text',
				'priority' => 28
			) );
		//front image
		/* $wp_customize->add_setting(
			'slider_front_img_3',
			array(
				'default' => '',
				'sanitize_callback' => 'esc_url_raw',
			) );
		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'slider_front_img_3',
				array(
				   'label'          => __( 'Upload your  front image for the third slide', 'profex' ),
				   'type'           => 'image',
				   'section'        => 'banner_bg_slider_section3',
				   'settings'       => 'slider_front_img_3',
				   'priority'       => 28,
				)
			) ); */
			
}

function profex_sanitize_wc_pos($value){
	$valid = array(
		'left'    => __('Left', 'profex'),
		'right'     => __('Right', 'profex'),
	);
	return ( array_key_exists( $value, $valid ) ? $value : '' );
}