<?php
/**
 * Background Mask Style - Floating Squares.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Floating_Squares
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Floating_Squares extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Floating Squares', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1723.8,1226.09l122,213.91H1920V0H849.49L628.61,596.91a131.67,131.67,0,0,1-169.19,77.8L0,504.71V1440H953.29l503.22-287C1550.51,1099.35,1670.18,1132.08,1723.8,1226.09ZM1637,210.26l82.29-33.21a18,18,0,0,1,23.44,10L1776,269.3a18,18,0,0,1-10,23.44L1683.7,326a18,18,0,0,1-23.44-10l-33.21-82.29A18,18,0,0,1,1637,210.26Z"/>',
					'portrait'  => '<path d="M546.09,1827.2,1384.51,1349c94-53.61,213.67-20.88,267.29,73.13L1920,1892.28V0H662.32l41.59,15.39a131.67,131.67,0,0,1,77.8,169.19L556.61,792.91a131.67,131.67,0,0,1-169.19,77.8L0,727.35V2560H738.49L473,2094.49C419.35,2000.49,452.08,1880.82,546.09,1827.2ZM1565,406.26l82.29-33.21a18,18,0,0,1,23.44,10L1704,465.3a18,18,0,0,1-10,23.44L1611.7,522a18,18,0,0,1-23.44-10l-33.21-82.29A18,18,0,0,1,1565,406.26Z"/>',
					'square'    => '<path d="M538.09,1667.2,1376.51,1189c94-53.61,213.67-20.88,267.29,73.13L1920,1746.31V0H780.21a132,132,0,0,1-6.5,24.58L548.61,632.91a131.67,131.67,0,0,1-169.19,77.8L0,570.31V1920H457.48C414.83,1828.52,448.85,1718.1,538.09,1667.2ZM1557,246.26l82.29-33.21a18,18,0,0,1,23.44,10L1696,305.3a18,18,0,0,1-10,23.44L1603.7,362a18,18,0,0,1-23.44-10l-33.21-82.29A18,18,0,0,1,1557,246.26Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M459.42,674.71,0,504.71V0H849.49L628.61,596.91A131.67,131.67,0,0,1,459.42,674.71ZM1723.8,1226.09c-53.62-94-173.29-126.74-267.29-73.13L953.29,1440h892.53ZM1660.26,316a18,18,0,0,0,23.44,10L1766,292.74a18,18,0,0,0,10-23.44L1742.74,187a18,18,0,0,0-23.44-10L1637,210.26a18,18,0,0,0-10,23.44Z"/>',
					'portrait'  => '<path d="M387.42,870.71,0,727.35V0H662.32l41.59,15.39a131.67,131.67,0,0,1,77.8,169.19L556.61,792.91A131.67,131.67,0,0,1,387.42,870.71ZM1920,1892.28l-268.2-470.19c-53.62-94-173.29-126.74-267.29-73.13L546.09,1827.2c-94,53.62-126.74,173.29-73.13,267.29L738.49,2560H1920ZM1588.26,512a18,18,0,0,0,23.44,10L1694,488.74a18,18,0,0,0,10-23.44L1670.74,383a18,18,0,0,0-23.44-10L1565,406.26a18,18,0,0,0-10,23.44Z"/>',
					'square'    => '<path d="M379.42,710.71,0,570.31V0H780.21a132,132,0,0,1-6.5,24.58L548.61,632.91A131.67,131.67,0,0,1,379.42,710.71ZM1920,1746.31l-276.2-484.22c-53.62-94-173.29-126.74-267.29-73.13L538.09,1667.2c-89.24,50.9-123.26,161.32-80.61,252.8H1920ZM1580.26,352a18,18,0,0,0,23.44,10L1686,328.74a18,18,0,0,0,10-23.44L1662.74,223a18,18,0,0,0-23.44-10L1557,246.26a18,18,0,0,0-10,23.44Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M1700.21,1201.49l-415.8-729A170.37,170.37,0,0,1,1348,240.14L1769,0H0V831.79a132,132,0,0,1,24.58,6.5l608.33,225.1a131.67,131.67,0,0,1,77.8,169.19L634,1440H1920V1271.57A170.37,170.37,0,0,1,1700.21,1201.49ZM352,339.74,269.7,373a18,18,0,0,1-23.44-10L213.05,280.7a18,18,0,0,1,10-23.44l82.29-33.21a18,18,0,0,1,23.44,10L362,316.3A18,18,0,0,1,352,339.74Z"/>',
					'portrait'  => '<path d="M1667.2,1381.91,1189,543.49c-53.61-94-20.88-213.67,73.13-267.29L1746.31,0H0V1139.4l632.6,231.5a130.82,130.82,0,0,1,77.9,167.81L468.44,2200.17a130.82,130.82,0,0,1-167.81,77.9L0,2168.05V2560H1920V1462.52C1828.52,1505.17,1718.1,1471.15,1667.2,1381.91ZM352,339.74,269.7,373a18,18,0,0,1-23.44-10L213.05,280.7a18,18,0,0,1,10-23.44l82.29-33.21a18,18,0,0,1,23.44,10L362,316.3A18,18,0,0,1,352,339.74Z"/>',
					'square'    => '<path d="M1667.2,1381.91,1189,543.49c-53.61-94-20.88-213.67,73.13-267.29L1746.31,0H0V1139.79a132,132,0,0,1,24.58,6.5l608.33,225.1a131.67,131.67,0,0,1,77.8,169.19L570.31,1920H1920V1462.52C1828.52,1505.17,1718.1,1471.15,1667.2,1381.91ZM352,339.74,269.7,373a18,18,0,0,1-23.44-10L213.05,280.7a18,18,0,0,1,10-23.44l82.29-33.21a18,18,0,0,1,23.44,10L362,316.3A18,18,0,0,1,352,339.74Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M213.05,280.7a18,18,0,0,1,10-23.44l82.29-33.21a18,18,0,0,1,23.44,10L362,316.3a18,18,0,0,1-10,23.44L269.7,373a18,18,0,0,1-23.44-10ZM634,1440l76.75-207.42a131.67,131.67,0,0,0-77.8-169.19L24.58,838.29A132,132,0,0,0,0,831.79V1440ZM1769,0,1348,240.14a170.37,170.37,0,0,0-63.57,232.39l415.8,729A170.37,170.37,0,0,0,1920,1271.57V0Z"/>',
					'portrait'  => '<path d="M1746.31,0,1262.09,276.2c-94,53.62-126.74,173.29-73.13,267.29l478.24,838.42c50.9,89.24,161.32,123.26,252.8,80.61V0ZM352,339.74a18,18,0,0,0,10-23.44L328.74,234a18,18,0,0,0-23.44-10L223,257.26a18,18,0,0,0-10,23.44L246.26,363a18,18,0,0,0,23.44,10Zm358.51,1199L468.44,2200.17a130.82,130.82,0,0,1-167.81,77.9L0,2168.05V1139.4l632.6,231.5A130.82,130.82,0,0,1,710.5,1538.71Z"/>',
					'square'    => '<path d="M710.71,1540.58,570.31,1920H0V1139.79a132,132,0,0,1,24.58,6.5l608.33,225.1A131.67,131.67,0,0,1,710.71,1540.58ZM1746.31,0,1262.09,276.2c-94,53.62-126.74,173.29-73.13,267.29l478.24,838.42c50.9,89.24,161.32,123.26,252.8,80.61V0ZM352,339.74a18,18,0,0,0,10-23.44L328.74,234a18,18,0,0,0-23.44-10L223,257.26a18,18,0,0,0-10,23.44L246.26,363a18,18,0,0,0,23.44,10Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Floating_Squares();
